package com.qboxus.tictic.simpleclasses

import android.content.Context
import android.util.Log
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import java.text.ParseException
import java.text.SimpleDateFormat
import java.time.Duration
import java.time.LocalTime
import java.time.ZoneId
import java.time.ZonedDateTime
import java.time.format.DateTimeFormatter
import java.time.format.DateTimeParseException
import java.util.Calendar
import java.util.Date
import java.util.Locale

object DateOprations {

    //use to get fomated time
    fun getTimeInMilli(dateFormat: String?, date: String?): Double {
        val calendarDate = Calendar.getInstance()
        val f = SimpleDateFormat(dateFormat, Locale.ENGLISH)
        var d: Date? = null
        try {
            d = f.parse(date)
            calendarDate.time = d
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return calendarDate.time.time.toDouble()
    }

    fun getCurrentDay(): Int {
        val calendar = Calendar.getInstance()
        val dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK)
        val day = dayOfWeek - 1
        if (day == 0) {
            return 6
        } else if (day == 1) {
            return  0
        } else if (day == 2) {
            return  1

        } else if (day == 3) {
            return  2
        } else if (day == 4) {
            return  3

        } else if (day == 5) {
            return  4

        } else if (day == 6) {
            return  5
        }

        else {
            return  0
        }

    }

    @JvmStatic
    fun millisecondsToMMSS(milliseconds: Long): String {
        val seconds = milliseconds / 1000
        val minutes = seconds / 60
        val remainingSeconds = seconds % 60
        return String.format("%02d:%02d", minutes, remainingSeconds)
    }


    @JvmStatic
    fun getDurationInDays(format: String?, start: String?, end: String?): String {
        return try {
            val startDateCal = Calendar.getInstance()
            val endDateCal = Calendar.getInstance()
            val f = SimpleDateFormat(format, Locale.ENGLISH)
            var startDate: Date? = null
            try {
                startDate = f.parse(start)
                startDateCal.time = startDate
            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception startDate: $e")
            }
            var endDate: Date? = null
            try {
                endDate = f.parse(end)
                endDateCal.time = endDate
            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception endDate: $e")
            }
            val difference = (endDateCal.timeInMillis - startDateCal.timeInMillis) / 1000
            val days = difference / 86400
            "" + days
        } catch (e: Exception) {
            Log.d(Constants.tag, "Exception days: $e")
            "0"
        }
    }

    @JvmStatic
    fun getDurationInPoints(format: String?, start: String?, end: String?): String {
        return try {
            val startDateCal = Calendar.getInstance()
            val endDateCal = Calendar.getInstance()
            val f = SimpleDateFormat(format, Locale.ENGLISH)
            var startDate: Date? = null
            try {
                startDate = f.parse(start)
                startDateCal.time = startDate
            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception startDate: $e")
            }
            var endDate: Date? = null
            try {
                endDate = f.parse(end)
                endDateCal.time = endDate
            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception endDate: $e")
            }
            val difference = (endDateCal.timeInMillis - startDateCal.timeInMillis) / 1000
            val days = difference.toDouble() / 86400
            "" + days
        } catch (e: Exception) {
            Log.d(Constants.tag, "Exception days: $e")
            "0"
        }
    }

    @JvmStatic
    fun changeDateLatterFormat(format: String?, context: Context, date: String): String {
        return try {
            val current_cal = Calendar.getInstance()
            val date_cal = Calendar.getInstance()
            val f = SimpleDateFormat(format, Locale.ENGLISH)
            var d: Date? = null
            try {
                d = f.parse(date)
                date_cal.time = d
            } catch (e: Exception) {
                e.printStackTrace()
            }
            val difference = (current_cal.timeInMillis - date_cal.timeInMillis) / 1000
            if (difference < 60) {
                difference.toString() + context.getString(R.string.s_ago)
            } else if (difference < 3600) {
                (0 + difference / 60).toString() + context.getString(R.string.m_ago)
            } else if (difference < 86400) {
                (0 + difference / 3600).toString() + context.getString(R.string.h_ago)
            } else if (difference < 604800) {
                (0 + difference / 86400).toString() + context.getString(R.string.d_ago)
            } else {
                if (difference < 2592000) {
                    (0 + difference / 604800).toString() + context.getString(R.string.week_ago)
                } else {
                    if (difference < 31536000) {
                        (0 + difference / 2592000).toString() + context.getString(R.string.month_ago)
                    } else {
                        (0 + difference / 31536000).toString() + context.getString(R.string.year_ago)
                    }
                }
            }
        } catch (e: Exception) {
            date
        }
    }

    @JvmStatic
    fun changeDateTodayYesterday(context: Context, date: String): String {
        return try {
            val current_cal = Calendar.getInstance()
            val date_cal = Calendar.getInstance()
            val f = SimpleDateFormat("dd-MM-yyyy HH:mm:ssZZ", Locale.ENGLISH)
            var d: Date? = null
            try {
                d = f.parse(date)
                date_cal.time = d
            } catch (e: Exception) {
                e.printStackTrace()
            }
            val difference = (current_cal.timeInMillis - date_cal.timeInMillis) / 1000
            if (difference < 86400) {
                if (current_cal[Calendar.DAY_OF_YEAR] - date_cal[Calendar.DAY_OF_YEAR] == 0) {
                    val sdf = SimpleDateFormat("hh:mm a", Locale.ENGLISH)
                    sdf.format(d)
                } else context.getString(R.string.yesterday)
            } else if (difference < 172800) {
                context.getString(R.string.yesterday)
            } else (difference / 86400).toString() + context.getString(R.string.day_ago)
        } catch (e: Exception) {
            date
        }
    }

    @JvmStatic
    fun checkTimeDiffernce(current_cal: Calendar, date: String): Boolean {
        return try {
            val date_cal = Calendar.getInstance()
            val f = SimpleDateFormat("dd-MM-yyyy HH:mm:ssZZ", Locale.ENGLISH)
            var d: Date? = null
            try {
                d = f.parse(date)
                date_cal.time = d
            } catch (e: Exception) {
                e.printStackTrace()
            }
            val difference = (current_cal.timeInMillis - date_cal.timeInMillis) / 1000
            if (difference < 0) {
                true
            } else {
                false
            }
        } catch (e: Exception) {
            false
        }
    }


    // getCurrent Date
    @JvmStatic
    fun getCurrentDate(dateFormat: String?): String {
        val format = SimpleDateFormat(dateFormat, Locale.ENGLISH)
        val date = Calendar.getInstance()
        return format.format(date.time)
    }

    // getCurrent Date
    @JvmStatic
    fun getCurrentDate(dateFormat: String?, days: Int): String {
        val format = SimpleDateFormat(dateFormat, Locale.ENGLISH)
        val date = Calendar.getInstance()
        date.add(Calendar.DAY_OF_MONTH, days)
        return format.format(date.time)
    }

    //use to get fomated time
    @JvmStatic
    fun getTimeWithAdditionalSecond(dateFormat: String?, second: Int): String {
        val calendarDate = Calendar.getInstance()
        val date = "00:00:00"
        val f = SimpleDateFormat("HH:mm:ss", Locale.ENGLISH)
        var d: Date? = null
        try {
            d = f.parse(date)
            calendarDate.time = d
        } catch (e: Exception) {
            e.printStackTrace()
        }
        val format = SimpleDateFormat(dateFormat, Locale.ENGLISH)
        calendarDate.add(Calendar.SECOND, second)
        return format.format(calendarDate.time)
    }

    @JvmStatic
    fun getTimeAgoOrg(date_time: String?): String {
        val timeAgo2 = TimeAgo2()
        return timeAgo2.covertTimeToText(date_time)
    }



    fun getRestaurantStatusMessage(timings: String, state: String,country:String): String {

        if(timings.contains("Open",true)){
            return timings
        }
        else if(!timings.contains(",")){
            return getstoreStatus(timings,state,country)
        }
        else if (timings.contains(",")){
            val parts = timings.split(", ")
            if(getStoreOpen(parts[0],state,country)){
                return getstoreStatus(parts[0],state,country)
            }
            else {
                return getstoreStatus(parts[1],state,country)
            }
        }
        else{
            return timings
        }
    }


    fun getstoreStatus(timings: String, state: String,country: String): String {
        try {
            val parts = timings.split(" - ")
            if (parts.size != 2) {
                return timings
            }

            val formatter = DateTimeFormatter.ofPattern("hh:mma")
            val openingTime = LocalTime.parse(parts[0], formatter)
            val closingTime = LocalTime.parse(parts[1], formatter)
            val crossingMidnight= closingTime.isBefore(openingTime)

            Functions.printLog(Constants.tag,"crossingMidnight:"+crossingMidnight)

            val timezone= getTimeZoneForState(state,country)

            var zoneID: ZoneId?=null
            try {
                zoneID= ZoneId.of(timezone)
            }catch (e:Exception){

            }
            var currentTime = ZonedDateTime.now()
            if (zoneID!=null){
                currentTime = ZonedDateTime.now(zoneID)
            }

            val midnightTime = getMidnightOfCurrentTimeZone(currentTime)

            val openingDateTime = currentTime.with(openingTime)
            val closingDateTime = currentTime.with(closingTime)
            val timeToClose = Duration.between(currentTime, closingDateTime).toMinutes()
            return when {
                timeToClose in 1..60 -> "Open, till ${timeToClose} minutes"

                currentTime.isAfter(openingDateTime) && currentTime.isBefore(closingDateTime) ->"Open"

                currentTime.isAfter(openingDateTime) && (crossingMidnight && currentTime.isAfter(midnightTime)) -> "Open"

                currentTime.isBefore(closingDateTime) && (crossingMidnight && currentTime.isAfter(midnightTime)) -> "Open"

                else -> "Closed now"
            }

        } catch (e: DateTimeParseException) {
            return "Closed now"
        } catch (e: IllegalArgumentException) {
            return "Closed now"
        }
    }

    fun getMidnightOfCurrentTimeZone(currentTime: ZonedDateTime): ZonedDateTime {
        // Extract the current date from the current time
        val currentDate = currentTime.toLocalDate()

        // Create a new ZonedDateTime instance for midnight
        val midnightTime = LocalTime.MIDNIGHT
        return ZonedDateTime.of(currentDate, midnightTime, currentTime.zone)
    }


    fun isStoreOpen(timings: String, state: String,country: String): Boolean{

        if(timings.contains("Open",true)){
            return true
        }
        else if(!timings.contains(",")){
            return getStoreOpen(timings,state,country)
        }
        else if (timings.contains(",")){
            val parts = timings.split(", ")
            if(getStoreOpen(parts[0],state,country)){
                return true
            }
            else {
                return getStoreOpen(parts[1],state,country)
            }
        }
        else{
            return false
        }
    }

    fun getStoreOpen(timings: String, state: String,country: String): Boolean {

        try {
            val parts = timings.split(" - ")
            if (parts.size != 2) {
                return false
            }

            val formatter = DateTimeFormatter.ofPattern("hh:mma")
            val openingTime = LocalTime.parse(parts[0], formatter)
            val closingTime = LocalTime.parse(parts[1], formatter)
            val crossingMidnight= closingTime.isBefore(openingTime)

            Functions.printLog(Constants.tag,"crossingMidnight:"+crossingMidnight)

            val timezone= getTimeZoneForState(state,country)

            var zoneID: ZoneId?=null
            try {
                zoneID= ZoneId.of(timezone)
            }catch (e:Exception){

            }
            var currentTime = ZonedDateTime.now()
            if (zoneID!=null){
                currentTime = ZonedDateTime.now(zoneID)
            }

            val midnightTime = getMidnightOfCurrentTimeZone(currentTime)

            val openingDateTime = currentTime.with(openingTime)
            val closingDateTime = currentTime.with(closingTime)


            return when {

                currentTime.isAfter(openingDateTime) && currentTime.isBefore(closingDateTime) ->true

                currentTime.isAfter(openingDateTime) && (crossingMidnight && currentTime.isAfter(midnightTime)) -> true

                currentTime.isBefore(closingDateTime) && (crossingMidnight && currentTime.isAfter(midnightTime)) ->true

                else -> false
            }
        }catch (e: DateTimeParseException) {
            return false
        } catch (e: IllegalArgumentException) {
            return false
        }
    }


    private fun getTimeZoneForState(stateCode: String,country: String): String? {
        val stateTimeZoneMap = mapOf(
            // United States
            "NY" to "America/New_York",
            "CA" to "America/Los_Angeles",
            "TX" to "America/Chicago",
            "FL" to "America/New_York",
            "IL" to "America/Chicago",
            // Canada
            "ON" to "America/Toronto",
            "BC" to "America/Vancouver",
            "QC" to "America/Montreal",
            "AB" to "America/Edmonton",
            "MB" to "America/Winnipeg",
            // Australia
            "NSW" to "Australia/Sydney",
            "VIC" to "Australia/Melbourne",
            "QLD" to "Australia/Brisbane",
            "WA" to "Australia/Perth",
            "SA" to "Australia/Adelaide",

            )

        if(stateTimeZoneMap.containsKey(stateCode)){
            return stateTimeZoneMap[stateCode]
        }
        else{
            return Functions.searchItemById(country)
        }
    }

    //This method will change the date format
    fun changeDateFormat(fromFormat: String, toFormat: String, date: String): String {
        val dateFormat = SimpleDateFormat(fromFormat, Locale.ENGLISH)
        var sourceDate: Date? = null
        return try {
            sourceDate = dateFormat.parse(date)
            val targetFormat = SimpleDateFormat(toFormat, Locale.ENGLISH)
            targetFormat.format(sourceDate)
        } catch (e: ParseException) {
            e.printStackTrace()
            Functions.printLog(Constants.tag,"e at date : $e")
            ""
        }
    }

}